DROP PROCEDURE [hips].[AddressGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Gordon
-- Create date: 15 October 2012
-- Description:   Gets a specified record from the Address Table
-- =============================================
CREATE PROCEDURE [hips].[AddressGet] 
(
	@AddressId INT
)
AS
BEGIN
SELECT  a.AddressId,
		a.AddressLine1,
		a.AddressLine2,
		a.PlaceName,
		a.AustralianStateId,
		st.Code AS AustralianStateCode,
		st.Description AS AustralianStateName,
		a.InternationalStateCode,
		a.PostCode,
		a.CountryId,
		c.DESCRIPTION AS CountryName,
		a.AddressTypeId,
		at.DESCRIPTION AS AddressTypeDescription,
		a.DateCreated,
		a.UserCreated,
		a.DateModified,
		a.UserModified
		
FROM  hips.Address a
LEFT OUTER JOIN hips.State AS st ON st.StateID = a.AustralianStateId
Inner JOIN hips.Country AS c ON c.CountryId = a.CountryId
INNER JOIN hips.AddressType AS at ON at.AddressTypeId = a.AddressTypeId
WHERE a.AddressId = @AddressId
END
GO

